/*
 * @(#)SimulatedAttribute.java  1.0  2006-03-20
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents an SimulatedAttribute of an EntitySet or of a RelationshipSet.
 * <p>
 * Important: equals and hashCode must be based on identity and not on the
 * attributes of this object.
 * <p>
 * FIMXE - Maybe this should be an interface.
 * 
 * @author Werner Randelshofer
 * @version 1.0 6. Februar 2004  Created.
 */
public class SimulatedAttribute extends AbstractBean implements Cloneable, DOMStorable {
    protected String name;
    
    /** Creates a new instance. */
    public SimulatedAttribute(String name) {
        this.name = name;
    }
    
    /**
     * This constructor is required for DOMStorable functionality.
     * Do <b>not</b> not use it for anything else.
     */
    public SimulatedAttribute() {
    }
    
    public void setName(String newValue) {
        String oldValue = name;
        this.name = newValue;
        firePropertyChange("name", oldValue, newValue);
        
    }
    public String getName() {
        return name;
    }
    public String getAttributeName() {
        int p = name.indexOf('=');
        return (p == -1) ? name : name.substring(0, p);
    }
    
    public SimulatedAttribute clone() {
            SimulatedAttribute that = (SimulatedAttribute) super.clone();
            return that;
    }
    
    public void read(DOMInput in) {
        name = in.getAttribute("name", "attribute");
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name, "attribute");
    }    
}
